/* -LICENSE-START-
 ** Copyright (c) 2015 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */
#pragma once

#include <QAbstractButton>
#include <QPixmap>
#include <QVariant>
#include <QVBoxLayout>

class QEvent;
class QPaintEvent;
class QString;
class QWidget;

class FlatImageButton: public QAbstractButton 
{
public:
	FlatImageButton(const QString& imageName, QWidget* parent = NULL);
	FlatImageButton(const QPixmap& image, QWidget* parent = NULL);
	FlatImageButton(QWidget* parent = NULL);

	virtual void setImage(const QString& imageName);
	virtual void setImage(const QPixmap& image);
	
	virtual void setHoverImage(const QString& imageName);
	virtual void setHoverImage(const QPixmap& image);
	
	virtual void setHoverBackgroundImage(const QString& imageName);
	
	virtual void setPressedImage(const QString& imageName);
	virtual void setPressedImage(const QPixmap& image);
	
	virtual void setCheckedImage(const QString& imageName);
	virtual void setCheckedImage(const QPixmap& image);
	
	virtual void setData(const QVariant& data);
	virtual const QVariant& data() const;
	
protected:
	void resizeToFit(const QPixmap& pixmap);
	virtual void paintEvent(QPaintEvent*);
	virtual void enterEvent(QEvent*);
	virtual void leaveEvent(QEvent*);

	QPixmap m_normal;
	QPixmap m_hover;
	QPixmap m_hoverBackground;
	QPixmap m_pressed;
	QPixmap m_checked;
	QVariant m_data;
};

class TightVBoxLayout: public QVBoxLayout
{
public:
	TightVBoxLayout(QWidget* parent = NULL): QVBoxLayout(parent)
	{
		setSpacing(0);
		setContentsMargins(0, 0, 0, 0);
	}
};

class TightHBoxLayout: public QHBoxLayout
{
public:
	TightHBoxLayout(QWidget* parent = NULL): QHBoxLayout(parent)
	{
		setSpacing(0);
		setContentsMargins(0, 0, 0, 0);
	}
};
